/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.LabelInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TextPart;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Message;
import de.willuhn.util.ApplicationException;
import java.text.SimpleDateFormat;
import org.eclipse.swt.widgets.Composite;

public class LogDetailDialog
extends AbstractDialog {
    private Message message = null;

    public LogDetailDialog(Message message, int position) {
        super(position);
        this.message = message;
        this.setTitle(Application.getI18n().tr("Details der System-Nachricht"));
        this.setSize(450, 300);
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent, true);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        container.addLabelPair(Application.getI18n().tr("Datum"), (Input)new LabelInput(df.format(this.message.getDate())));
        Level level = this.message.getLevel();
        LabelInput l = new LabelInput(level.getName());
        if (level.getValue() <= Level.DEBUG.getValue()) {
            l.setColor(Color.COMMENT);
        } else if (level.getValue() == Level.WARN.getValue()) {
            l.setColor(Color.LINK_ACTIVE);
        } else if (level.getValue() >= Level.ERROR.getValue()) {
            l.setColor(Color.ERROR);
        }
        container.addLabelPair(Application.getI18n().tr("Priorit\u00e4t"), (Input)l);
        container.addLabelPair(Application.getI18n().tr("Quelle"), (Input)new LabelInput(this.message.getLoggingClass() + "." + this.message.getLoggingMethod()));
        container.addHeadline(Application.getI18n().tr("Nachricht"));
        TextPart tp = new TextPart();
        tp.setAutoscroll(false);
        tp.setWordWrap(true);
        tp.appendText(this.message.getText());
        container.addPart(tp);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(Application.getI18n().tr("Schlie\u00dfen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                LogDetailDialog.this.close();
            }
        }, null, true, "process-stop.png");
        container.addButtonArea(buttons);
    }

    protected Object getData() throws Exception {
        return null;
    }
}

